/****************************************************************************
 **                                                                        **
 **  "Bong" 64K intro - Aron, 1998.05.12                                   **
 **                                                                        **
 ****************************************************************************/

// - sajat fejlecfile-ok ----------------------------------------------------
#include "compile.h"
#include "defs.h"
#include "main.h"
#include "tinymath.h"   // tiny math macros, (C) cubic team
#include "bitmap.h"
#include "mxmplay.h"    // tiny XM player, (C) cubic team
#include "utils.h"
#include "texture.h"
#include "tracer.h"
#include "video.h"

// - implementacio ----------------------------------------------------------
byte mainframebuffer[4*320*200],
     tempframebuffer[4*320*200],
     plusframebuffer[4*320*200],
     texturebuffer[TEXTURES_GENERATED*TEXTURE_SIZE],
     blurbuffer[IMAGES_BLURRED*PHASES_BLURRED*BLURBUFFER_SIZE],
     meme[100000],
     mxmplaymemory[16*1024];

void main(int argc,char *argv[])
{ dword videomodenr,selected_videomode= 0;
  dword timer,timerstarted= 0;
  byte keypressed= 0;
  int i,j,k;
  float t;

  CAMERA camera;
  OMNI_LIGHTSOURCE lightsource;

  char *greetxtext[GREETX_STRINGS]= { "{a  s  t  r  o  i  d  e  a",
                                      "{c  h  r  o  m  e",
                                      "{c  o  d  e  r  } l",
                                      "{d  i  l  e  m  m  a",
                                      "{d  i  n  a  s  t  y",
                                      "{e  x  c  e  e  d",
                                      "{e  x  h  u  m  e  r  s",
                                      "{e  u  t  h  a  n  a  s  i  a",
                                      "{m  a  n  d  u  l  a",
                                      "{p  r  o  f  u  s  e",
                                      "{r  h  y  m  e",
                                      "{u  n  i  t  e  d   f  o  r  c  e",
                                      "{{{",
                                      "{w  e   a  d  o  r  e   y  o  u" };
  char titletext[]= "independent love song{",temptext[64];

  extern byte Phongmap[256*256];;
  extern byte musicdata[28562];

  extern byte astrospicdata[32*32];
  extern byte astros2picdata[32*32];
  extern byte arabianpicdata[32*32];
  extern byte childpicdata[32*32];
  extern byte spacelegpicdata[32*32];
  extern byte plantpicdata[32*32];
  extern byte saintpicdata[32*32];
  extern byte logodata[16*3 + 214*104/2];

  // video inicializalas (LFB mutato megnovelese 320x10xbpp-vel):
  PutText("  \"(independent) love bong\" by contract at the contest 99 $");

  // videomod meghatarozasa:
  if(argv[1][0] == '1')
  { PutText("\n\n\r initializing 320x200x16bpp with LFB...$");

    selected_videomode= 1;
  }
  else if(argv[1][0] == '2')
  { PutText("\n\n\r initializing 320x200x24bpp with LFB...$");

    selected_videomode= 2;
  }
  else if(argv[1][0] == '3')
  { PutText("\n\n\r initializing 320x200x32bpp with LFB...$");

    selected_videomode= 3;
  }

  if(selected_videomode)
  { // VESA mod szamank lekerdezese:
    if(GetVESAInfo() < 0x0200) { PutText("\n\r vbe2.0+ interface not found!$"); return; }
    videomodenr= Detect320x200Mode(16 + (selected_videomode - 1)*8,&LFBptr);
#ifdef VIDEO_OWNMATROX
    videomodenr= 1;
    LFBptr= (dword)(3712*1024*1024);
#endif
    if(!videomodenr || !LFBptr) { PutText("\n\r specified videomode not found!$"); return; }

    // LFB-re mutato megnovelese az elso 10 sorral:
    LFBptr+= 320*10*(1 + selected_videomode);
  }
  else
  { PutText("\n\n\r initializing 320x400x12bpp...$");

    selected_videomode= 0;
    LFBptr= (dword)(0xA0000 + 320*20);
  }

  // prekalkulaciok es texturak generalasa:
  PutText("\n\r decrunching wavelet compressed animation...$");
  InitTables(); PutChar('.');
  InitPolarizator(); PutChar('.');
#ifdef PART_WORMHOLE
  PutText("\n\r triangulating fake raytraced spheres...$");
  InitWormhole(); PutChar('.');
#endif
  PutText("\n\r precalculating refraction tables for all the polygons...$");
  InitTextures(texturebuffer); PutChar('.');

  // intro animaciok blur-olese:
#ifdef PART_STARTBLURER
  DrawMiniPicture(blurbuffer + 4*(320*70 + 35),spacelegpicdata);
  DrawString("a           r           o           n{",blurbuffer,30,85,255);
  InitBlurer(blurbuffer,SPIN_BLUR); PutChar('.');
  DrawMiniPicture(blurbuffer + PHASES_BLURRED*BLURBUFFER_SIZE + 4*(320*50 + 195),saintpicdata);
  DrawString("x           t           r           o{",blurbuffer + PHASES_BLURRED*BLURBUFFER_SIZE,30,85,255);
  InitBlurer(blurbuffer + PHASES_BLURRED*BLURBUFFER_SIZE,SPIN_BLUR); PutChar('.');
  DrawMiniPicture(blurbuffer + 2*PHASES_BLURRED*BLURBUFFER_SIZE + 4*(320*60 + 55),arabianpicdata);
  DrawString("z      o      o      l      e      y{",blurbuffer + 2*PHASES_BLURRED*BLURBUFFER_SIZE,30,85,255);
  InitBlurer(blurbuffer + 2*PHASES_BLURRED*BLURBUFFER_SIZE,SPIN_BLUR); PutChar('.');
#endif
#ifdef PART_ENDBLURER
  DrawMiniPicture(blurbuffer + 3*PHASES_BLURRED*BLURBUFFER_SIZE + 4*(320*57 + 35),astros2picdata);
  DrawString("c    o    n    t    r    a    c   t{",blurbuffer + 3*PHASES_BLURRED*BLURBUFFER_SIZE,24,70,230.0 + 25.0*fsin(300.0*t));
  DrawString("h     u     n     g     a     r     y{",blurbuffer + 3*PHASES_BLURRED*BLURBUFFER_SIZE,22,90,230.0 + 25.0*fsin(300.0*t));
  InitBlurer(blurbuffer + 3*PHASES_BLURRED*BLURBUFFER_SIZE,SPIN_BLUR); PutChar('.');
#endif

  // MXMPLAY inicializalas:
#ifdef PLAYER_PLAYMUSIC
  if(!xmpInit(musicdata,xmpGetGUSPort(xmpGetEnvPtrDPMI(_psp)),mxmplaymemory,65536,MXMINTMODEDOS)) return;
#endif

  // inditas:
  FadeOutTextScreen();
#ifdef VIDEO_OWNMATROX
  if(selected_videomode == 0) SetFakeMode(); else SetVESAMode(0x4112);
#else
  if(selected_videomode == 0) SetFakeMode(); else SetVESAMode(videomodenr);
#endif

  // generalt texturak megmutatasa:
#ifdef GENERATOR_SHOWTEXTURES
  FillFrameBuffer(mainframebuffer,0x00000000);
  for(timer=0; timer<TEXTURES_GENERATED; timer++)
  { for(i=0; i<180; i++) for(j=0; j<256; j++)
    { *(mainframebuffer + 4*(320*i + 32 + j) + 0)= *(texturebuffer + timer*TEXTURE_SIZE + 4*(256*i + j) + 0);
      *(mainframebuffer + 4*(320*i + 32 + j) + 1)= *(texturebuffer + timer*TEXTURE_SIZE + 4*(256*i + j) + 1);
      *(mainframebuffer + 4*(320*i + 32 + j) + 2)= *(texturebuffer + timer*TEXTURE_SIZE + 4*(256*i + j) + 2);
    }
    UpdateScreen[selected_videomode](mainframebuffer);
    WaitKey();
  }
#endif

  // blur-olt animaciok megmutatasa:
#ifdef BLURER_SHOWANIMS
  FillFrameBuffer(mainframebuffer,0x00000000);
  for(timer=0; timer<IMAGES_BLURRED*PHASES_BLURRED; timer++)
  { for(i=0; i<180; i++) for(j=0; j<320; j++)
    { *(mainframebuffer + 4*(320*i + j) + 0)= *(blurbuffer + timer*BLURBUFFER_SIZE + 4*(320*i + j) + 0);
      *(mainframebuffer + 4*(320*i + j) + 1)= *(blurbuffer + timer*BLURBUFFER_SIZE + 4*(320*i + j) + 1);
      *(mainframebuffer + 4*(320*i + j) + 2)= *(blurbuffer + timer*BLURBUFFER_SIZE + 4*(320*i + j) + 2);
    }
    UpdateScreen[selected_videomode](mainframebuffer);
    WaitKey();
  }
#endif

  // Phong-map megmutatasa:
#ifdef BITMAP_SHOWPHONGMAP
  FillFrameBuffer(mainframebuffer,0x00000000);
  for(i=0; i<180; i++) for(j=0; j<256; j++)
  { *(mainframebuffer + 4*(320*i + j) + 0)= *(Phongmap + 256*i + j);
    *(mainframebuffer + 4*(320*i + j) + 1)= *(Phongmap + 256*i + j);
    *(mainframebuffer + 4*(320*i + j) + 2)= *(Phongmap + 256*i + j);
  }
  UpdateScreen[selected_videomode](mainframebuffer);
  WaitKey();
#endif

  // lejatszas elinditasa:
#ifdef PLAYER_PLAYMUSIC
  xmpPlay(MUSIC_STARTPOS);
#endif

// - intro ------------------------------------------------------------------
  while((xmpGetPos() < MUSICPOS(0x04,0)) && (!keypressed))
  { // timer lekerdezese:
    timer= xmpGetTimer()/(1193046 / TIMER_RATE);
    // dobra szinkronizalt blur-olt animaciok:
    i= xmpGetPos()>>8; j= 7 - xmpGetSync();
    if(i == 0x01) DrawBlurredImage(mainframebuffer,blurbuffer + j*BLURBUFFER_SIZE);
    else if(i == 0x02) DrawBlurredImage(mainframebuffer,blurbuffer + (PHASES_BLURRED + j)*BLURBUFFER_SIZE);
    else if(i == 0x03) DrawBlurredImage(mainframebuffer,blurbuffer + + (2*PHASES_BLURRED + j)*BLURBUFFER_SIZE);
    UpdateScreen[selected_videomode](mainframebuffer);
    if(CheckKeys()) keypressed= 1;
  }
// --------------------------------------------------------------------------

// - scene: gombok egy reflexiv sik felett ----------------------------------
  SetupSpheresScene(texturebuffer);
  camera.FOV= 1.0;
  timerstarted= 0;
  while((xmpGetPos() < MUSICPOS(0x08,0)) && (!keypressed))
  { // timer lekerdezese:
    timer= xmpGetTimer()/(1193046 / TIMER_RATE); i= timer - timerstarted; t= i / 200.0;
    // trace-eles ket kameraval:
    j= xmpGetPos();
    if(((j>>8) == 0x05) || ((j>>8) == 0x07))
    { camera.position.X= 100.0*fsin(0.5*t);
      camera.position.Y= 100.0 + 10.0*t;
      camera.position.Z= 100.0*fcos(0.7*t);
      camera.target.X= 15.0*fcos(0.7*t);
      camera.target.Y= 10.0 + 8.0*fsin(0.9*t);
      camera.target.Z= 15.0*fcos(t);
      camera.roll= M_PI - fsin(0.3*t);
    }
    else
    { camera.position.X= 150.0*fsin(2.0*t);
      camera.position.Y= 50.0 + 30.0*fsin(1.2*t);
      camera.position.Z= 130.0*fcos(2.7*t);
      camera.target.X= 25.0*fcos(0.5*t);
      camera.target.Y= 10.0 + 8.0*fsin(1.3*t);
      camera.target.Z= 15.0*fcos(1.1*t);
      camera.roll= M_PI + fsin(0.4*t);
    }
    lightsource.position.X= 150.0*fsin(2.0*t);
    lightsource.position.Y= 90 + 25.0*fsin(4.0*t);
    lightsource.position.Z= 150.0*fcos(2.0*t);
    AnimateSpheresScene(3.0*t);
    TraceScene(mainframebuffer,&camera,&lightsource,NOT_USE_RAY_PERTURBANCE);
    InterpolateFrameBuffer(mainframebuffer);
    // elejen strobo:
    if(j < MUSICPOS(0x04,17)) HandleStrobo(mainframebuffer,255 - ((j & 0xFF)<<4));
    // vegen kifade-eles:
    if((j>>8) == 0x07) FadeFrameBuffer(mainframebuffer,255 - ((j & 0xFF)<<2));
    UpdateScreen[selected_videomode](mainframebuffer);
    if(CheckKeys()) keypressed= 1;
  }
// --------------------------------------------------------------------------

// - logo -------------------------------------------------------------------
  timerstarted= timer;
  DrawLogo(plusframebuffer + 4*(320*15 + 40));
  FillFrameBuffer(tempframebuffer,0x00000000);
  FillFrameBuffer(mainframebuffer,0x00000000);
  while((xmpGetPos() < MUSICPOS(0x0C,0)) && (!keypressed))
  { // timer lekerdezese:
    timer= xmpGetTimer()/(1193046 / TIMER_RATE); i= timer - timerstarted; t= i / 20.0;
    // torzitas:
    RecalcTorsionTable((signed int)(-800.0 + 90.0*fsin(1.2*t)),(signed int)(700.0 + 90.0*fcos(1.4*t)),(signed int)(1250.0 + 90.0*fcos(1.3*t)),(signed int)(-750.0 + 90.0*fsin(1.1*t)));
    DistortBitmap(mainframebuffer,plusframebuffer);
    // felirat:
    j= xmpGetPos();
    if((j>>8) > 0x08)
    { if((j>>8) == 0x09)
      { j&= 0xFF;
        if(j < 30)
        { // "independent love song":
          i= 0;
          while((titletext[i] != '\0') && (i < j)) { temptext[i]= titletext[i]; i++; }
        }
        else if(j < (30 + 4))
        { // visszatorles, javitas "bong"-ra:
          i= 0;
          while((titletext[i] != '\0') && (i < (17 + 33 - j))) { temptext[i]= titletext[i]; i++; }
          if(j == 33) titletext[17]= 'b';
        }
        else if(j < (30 + 4 + 4))
        { // ujrairas:
          i= 0;
          while((titletext[i] != '\0') && (i < (17 + j - 34))) { temptext[i]= titletext[i]; i++; }
        }
        else
        { // teljes kiiras:
          i= 0;
          while((titletext[i] != '\0') && (i < 30)) { temptext[i]= titletext[i]; i++; }
        }
      }
      else
      { // teljes kiiras:
        i= 0;
        while((titletext[i] != '\0') && (i < 30)) { temptext[i]= titletext[i]; i++; }
      }
      temptext[i]= ' ';
      if((xmpGetPos() & 0x0F) < 8) temptext[i + 1]= '|'; else temptext[i + 1]= ' ';
      temptext[i + 2]= '\0';
      DrawString(temptext,mainframebuffer,20,85,230.0 + 25.0*fsin(5.0*t));
    }
    // elejen befade-eles:
    if((j>>8) == 0x08) FadeFrameBuffer(mainframebuffer,(j & 0xFF)<<2);
    UpdateScreen[selected_videomode](mainframebuffer);
    if(CheckKeys()) keypressed= 1;
  }
// --------------------------------------------------------------------------

// - scene: hullamzo csovek egy gomb belsejeben -----------------------------
  SetupPipeScene(texturebuffer);
  timerstarted= timer;
  while((xmpGetPos() < MUSICPOS(0x10,0)) && (!keypressed))
  { // timer lekerdezese:
    timer= xmpGetTimer()/(1193046 / TIMER_RATE); i= timer - timerstarted; t= i / 100.0;
    // trace-eles:
    camera.position.X= 200.0*fsin(1.2*t);
    camera.position.Y= 100.0;
    camera.position.Z= 200.0*fcos(1.1*t);
    camera.target.X= 30.0*fsin(0.7*t);
    camera.target.Y= 0.0;
    camera.target.Z= 30.0*fsin(1.5*t);
    camera.roll= M_PI + 2.0*t;
    lightsource.position.X= 150.0*fsin(2.0*t);
    lightsource.position.Y= 150.0;
    lightsource.position.Z= 150.0*fcos(2.0*t);
    TraceScene(mainframebuffer,&camera,&lightsource,USE_RAY_PERTURBANCE);
    InterpolateFrameBuffer(mainframebuffer);
    // befade-eles:
    j= xmpGetPos();
    if((j>>8) == 0x0C) FadeFrameBuffer(mainframebuffer,(j & 0xFF)<<2);
    UpdateScreen[selected_videomode](mainframebuffer);
    if(CheckKeys()) keypressed= 1;
  }
// --------------------------------------------------------------------------

// - texturapolarizator -----------------------------------------------------
  timerstarted= timer;
  while((xmpGetPos() < MUSICPOS(0x14,0)) && (!keypressed))
  { // timer lekerdezese:
    timer= xmpGetTimer()/(1193046 / TIMER_RATE); i= timer - timerstarted; t= i / 50.0;
    // tripla texturapolarizator:
    j= xmpGetPos()>>8;
    if((j == 0x10) || (j == 0x12))
     PolarizeBitmap(tempframebuffer,
                    (520*(dword)(50 + 50.0*fsin(t)) + (dword)(100 + 100*fcos(0.8*t)))<<1,
                    (520*(dword)(50 + 50.0*fcos(1.7*t)) + (dword)(100 + 100*fsin(t)))<<1,
                    (520*(dword)(50 + 50.0*fcos(2.3*t)) + (dword)(100 + 100*fcos(1.3*t)))<<1,
                    texturebuffer + 1*TEXTURE_SIZE,128.0 + 128.0*fsin(1.7*t),
                    i<<1,
                    texturebuffer + 5*TEXTURE_SIZE,128.0 + 128.0*fcos(1.3*t),256 - (i<<1));
    else
     PolarizeBitmap(tempframebuffer,
                    (520*(dword)(50 + 50.0*fsin(t)) + (dword)(100 + 100*fcos(0.8*t)))<<1,
                    (520*(dword)(50 + 50.0*fcos(1.7*t)) + (dword)(100 + 100*fsin(t)))<<1,
                    (520*(dword)(50 + 50.0*fcos(2.3*t)) + (dword)(100 + 100*fcos(1.3*t)))<<1,
                    texturebuffer + 0*TEXTURE_SIZE,128.0 + 128.0*fsin(1.7*t),
                    i<<1,
                    texturebuffer + 3*TEXTURE_SIZE,128.0 + 128.0*fcos(1.3*t),256 - (i<<1));
    DrawSquares(tempframebuffer);
    CopyFrameBuffer(mainframebuffer,tempframebuffer);
    DrawMiniPicture(mainframebuffer + 4*(320*24 + 165),astrospicdata);
    DrawMiniPicture(mainframebuffer + 4*(320*24 + 230),astros2picdata);
    DrawMiniPicture(mainframebuffer + 4*(320*89 + 165),plantpicdata);
    DrawMiniPicture(mainframebuffer + 4*(320*89 + 230),childpicdata);
    // szinkronizalt rangatas:
    j= xmpGetSync();
    if(j)
    { TwitchFrameBuffer(plusframebuffer,mainframebuffer,j);
      UpdateScreen[selected_videomode](plusframebuffer);
    }
    else
    { // villantas:
      j= xmpGetPos() & 0xFF;
      if(j < 16) { i= (j & 0xFF)<<4; BlinkFrameBuffer(mainframebuffer,i); }
      UpdateScreen[selected_videomode](mainframebuffer);
    }
    if(CheckKeys()) keypressed= 1;
  }
// --------------------------------------------------------------------------

// - scene: forgo kocka a kozepen reflexiv gombbel --------------------------
  SetupCubeScene(texturebuffer);
  timerstarted= timer;
  while((xmpGetPos() < MUSICPOS(0x18,0)) && (!keypressed))
  { // timer lekerdezese:
    timer= xmpGetTimer()/(1193046 / TIMER_RATE); i= timer - timerstarted; t= i/100.0;
    // trace-eles ket kameraval:
    j= xmpGetPos();
    if(((j>>8) == 0x15) || ((j>>8) == 0x17))
    { camera.position.X= 150.0*fsin(0.5*t);
      camera.position.Y= 150.0 + 10.0*t;
      camera.position.Z= 150.0*fsin(1.3*t);
      camera.target.X= 15.0*fcos(0.7*t);
      camera.target.Y= 10.0 + 8.0*fsin(0.9*t);
      camera.target.Z= 15.0*fcos(t);
      camera.roll= M_PI - fsin(0.5*t);
    }
    else
    { camera.position.X= 150.0*fsin(1.2*t);
      camera.position.Y= 120.0*fcos(0.7*t);
      camera.position.Z= 140.0*fcos(2*t);
      camera.target.X= 20.0*fcos(1.5*t);
      camera.target.Y= 20.0*fsin(1.3*t);
      camera.target.Z= 20.0*fcos(t);
      camera.roll= M_PI;
    }
    lightsource.position.X= 150.0*fsin(2.1*t);
    lightsource.position.Y= 90 + 25.0*fsin(4.0*t);
    lightsource.position.Z= 150.0*fsin(1.3*t);
    AnimateCubeScene(t);
    TraceScene(mainframebuffer,&camera,&lightsource,NOT_USE_RAY_PERTURBANCE);
    InterpolateFrameBuffer(mainframebuffer);
    // elejen strobo:
    j= xmpGetPos();
    if(j < MUSICPOS(0x14,17)) HandleStrobo(mainframebuffer,255 - ((j & 0xFF)<<4));
    UpdateScreen[selected_videomode](mainframebuffer);
    if(CheckKeys()) keypressed= 1;
  }
// --------------------------------------------------------------------------

// - wormhole bump ----------------------------------------------------------
  timerstarted= timer;
  FillFrameBuffer(plusframebuffer,0x00000000);
  while((xmpGetPos() < MUSICPOS(0x1C,0)) && (!keypressed))
  { // timer lekerdezese:
    timer= xmpGetTimer()/(1193046 / TIMER_RATE); i= timer - timerstarted; t= i / 35.0;
    // csikos wormhole bump:
    DrawWormHole(tempframebuffer,texturebuffer + 4*TEXTURE_SIZE,texturebuffer + 3*TEXTURE_SIZE,i>>1);
    FillFrameBuffer(mainframebuffer,0x00000000);
    DrawBump(mainframebuffer,tempframebuffer,50.0 + 40.0*fsin(0.7*t),115 + 25.0*fcos(t));
    DrawInvertedStripe(mainframebuffer,i>>1);
    // villantas es keret torlese:
    BlinkFrameBuffer(mainframebuffer,(dword)(128.0 + 127.0*fsin(t)));
    HideBorders(mainframebuffer);
    // dobra szinkronizalt sztringleptetes:
    i= xmpGetSync(); j= xmpGetPos();
    k= 5*((j>>8) - 0x18) + ((i & 0xF0)>>4); if(k > 15) k= 15;
    // greetx szoveg:
    if(k < 8) for(i=0; i<k; i++) DrawString(greetxtext[i],mainframebuffer,30,5 + i*25,230.0 + 25.0*fsin(5.0*t));
     else for(i=0; i<(k - 8); i++) DrawString(greetxtext[7 + i],mainframebuffer,30,5 + i*25,230.0 + 25.0*fsin(5.0*t));
    // elejen strobo:
    j= xmpGetPos();
    if(j < MUSICPOS(0x18,17)) HandleStrobo(mainframebuffer,255 - ((j & 0xFF)<<4));
    // vegen szinkronizalva valtas:
    i= xmpGetSync();
    if(i == 1) UpdateScreen[selected_videomode](plusframebuffer);
    else UpdateScreen[selected_videomode](mainframebuffer);
    if(CheckKeys()) keypressed= 1;
  }
// --------------------------------------------------------------------------

// - scene: uveggolyo egy lezart csoben -------------------------------------
  SetupMirrorBallScene(texturebuffer);
  timerstarted= timer; k= 0;
  while((xmpGetPos() < MUSICPOS(0x20,0)) && (!keypressed))
  { // timer lekerdezese:
    timer= xmpGetTimer()/(1193046 / TIMER_RATE); i= timer - timerstarted; t= i / 140.0;
    if(i < 730)
    { // trace-eles:
      camera.position.X= 200.0*fcos(2.0*t);
      camera.position.Y= 0.0;
      camera.position.Z= 200.0*fsin(2.0*t);
      camera.target.X= 0.0;
      camera.target.Y= 0.0;
      camera.target.Z= 0.0;
      camera.roll= M_PI*fcos(t);
      lightsource.position.X= 100.0*fsin(2.0*t);
      lightsource.position.Y= 0;
      lightsource.position.Z= 100.0*fcos(2.0*t);
      AnimateMirrorBallScene(t);
      TraceScene(mainframebuffer,&camera,&lightsource,NOT_USE_RAY_PERTURBANCE);
      InterpolateFrameBuffer(mainframebuffer);
      // elejen befade-eles:
      j= xmpGetPos();
      if((j>>8) == 0x1C) FadeFrameBuffer(mainframebuffer,(j & 0xFF)<<2);
    }
    else
    { // fekete-feherbe strobo:
      if(k == 0) ConvertMonoFrameBuffer(tempframebuffer,mainframebuffer);
      CopyFrameBuffer(mainframebuffer,tempframebuffer);
      k= (i - 730)<<5;
      if(k) HandleStrobo(mainframebuffer,255 - k);
    }
    UpdateScreen[selected_videomode](mainframebuffer);
    if(CheckKeys()) keypressed= 1;
  }
// --------------------------------------------------------------------------

// - scene: refraktiv gomb oszlopok kozott ----------------------------------
  SetupColumnsScene(texturebuffer);
  timerstarted= timer;
  while((xmpGetPos() < MUSICPOS(0x22,0)) && (!keypressed))
  { // timer lekerdezese:
    timer= xmpGetTimer()/(1193046 / TIMER_RATE); i= timer - timerstarted; t= i/100.0;
    // trace-eles:
    camera.position.X= 200.0*fcos(1.3*t);
    camera.position.Y= 80.0 + 30.0*fsin(0.7*t);
    camera.position.Z= 300.0*fsin(1.3*t);
    camera.target.X= 30.0*fcos(1.3*t);
    camera.target.Y= 20.0 + 10.0*fsin(t);
    camera.target.Z= 30.0*fsin(1.7*t);
    camera.roll= M_PI + 2.0*t;
    lightsource.position.X= 180.0*fsin(2.0*t);
    lightsource.position.Y= 80.0 + 30.0*fsin(0.6*t);
    lightsource.position.Z= 180.0*fcos(1.7*t);
    TraceScene(mainframebuffer,&camera,&lightsource,NOT_USE_RAY_PERTURBANCE);
    InterpolateFrameBuffer(mainframebuffer);
    // elejen strobo:
    j= xmpGetPos();
    if(j < MUSICPOS(0x20,17)) HandleStrobo(mainframebuffer,255 - ((j & 0xFF)<<4));
    UpdateScreen[selected_videomode](mainframebuffer);
    if(CheckKeys()) keypressed= 1;
  }
// --------------------------------------------------------------------------

// - legyszem zoomer es befejezo animacio -----------------------------------
  CopyFrameBuffer(plusframebuffer,mainframebuffer);
  timerstarted= timer;
  while((xmpGetPos() < MUSICPOS(0x25,0)) && (!keypressed))
  { // timer lekerdezese:
    timer= xmpGetTimer()/(1193046 / TIMER_RATE); i= timer - timerstarted; t= 0.4 + i/1000.0;
    // csikos legyszem zoomer:
    i= xmpGetPos();
    if((i>>8) < 0x24)
    { DrawZoomer(mainframebuffer,texturebuffer + 3*TEXTURE_SIZE,t);
      DrawFlyEye(mainframebuffer);
      DrawStripes(mainframebuffer);
      // hatter kifade-elese:
      if((i>>8) == 0x23) FadeFrameBuffer(mainframebuffer,255 - (i&0xFF)<<2);
      DrawMiniPicture(mainframebuffer + 4*(320*57 + 35),astros2picdata);
      DrawString("c    o    n    t    r    a    c   t{",mainframebuffer,24,70,255);
      DrawString("h     u     n     g     a     r     y{",mainframebuffer,22,90,255);
      // crossfade-eles:
      if((i>>8) == 0x22) CrossFadeFrameBuffer(mainframebuffer,plusframebuffer,(i&0xFF)<<2);
    }
    else if((i>>8) == 0x24)
    { DrawBlurredImage(mainframebuffer,blurbuffer + (3*PHASES_BLURRED + (dword)(7.0 - 7.0*ffabs(fcos(63.4*(t - 0.4))*fsin(57.3*(t - 0.4)))))*BLURBUFFER_SIZE);
      if((i>>8) == 0x24) FadeFrameBuffer(mainframebuffer,255 - (i&0xFF)<<2);
    }
    UpdateScreen[selected_videomode](mainframebuffer);
    if(CheckKeys()) keypressed= 1;
  }
// --------------------------------------------------------------------------

  // MXMPLAY deinicializalas:
#ifdef PLAYER_PLAYMUSIC
  xmpStop();
#endif

  // vege:
  SetVGAMode(3);
  PutText("ron gombs   : software engineer\n\rgbor nagy    : illustrator\n\rzoltn illys : sound engineer\n\n\rthe contest 99\n\rbudapest, hungary\n\r$");
}
